package bluetooth.Trump;

import java.io.Serializable;
import java.util.Random;

public class ViewInfo implements Serializable{

	private static final long serialVersionUID = 1L;
	
	private boolean start = false;
	private Random rnd;
	private boolean[] turnDraw; 
	private boolean[] turnPass; 
	
	private int[] spade;
	private int[] clover;
	private int[] heart;
	private int[] dia;
	
	ViewInfo(){
		this.start = true;
		rnd = new Random();
		
		spade = new int[14];
		clover = new int[14];
		heart = new int[14];
		dia = new int[14];
		for(int i=0;i<14;i++){
			spade[i]=0;
			clover[i]=0;
			heart[i]=0;
			dia[i]=0;
		}
		
		turnDraw = new boolean[3];
		turnPass = new boolean[3];
		
		for(int i=0;i<3;i++){
			turnDraw[i]=false;
			turnPass[i]=false;
		}
		
		
	}
	
	public boolean getStart(){
		return start;
	}
	
	public void setStart(boolean start){
		this.start = start;
	}
	
	public int[] getSpade(){
		return this.spade;
	}
	
	public int[] getClover(){
		return this.clover;
	}
	
	public int[] getHeart(){
		return this.heart;
	}
	
	public int[] getDia(){
		return this.dia;
	}
	
	public boolean[] getTurnDraw(){
		return this.turnDraw;
	}
	
	public boolean[] getTurnPass(){
		return this.turnPass;
	}
	
	public void setTurnDraw(boolean[] turnDraw){
		this.turnDraw = turnDraw;
	}
	
	public void setTurnPass(boolean[] turnPass){
		this.turnPass = turnPass;
	}
	
	
	public void drawCard(int playernumber){
		
		boolean next=true;
		while(next){
			int random = rnd.nextInt(52);
			int number = (random / 4) + 1;
			switch(random % 4){
			case 0:
				if(spade[number]==0){
					spade[number]=playernumber;
					next=false;
				}
				break;
			case 1:
				if(clover[number]==0){
					clover[number]=playernumber;
					next=false;
				}
				break;
			case 2:
				if(heart[number]==0){
					heart[number]=playernumber;
					next=false;
				}
				break;
			case 3:
				if(dia[number]==0){
					dia[number]=playernumber;
					next=false;
				}
				break;
			}
		}
				
	}
	
	public int calculate(int playernumber){
		int sum = 0;
		
		for(int i=13;i>9;i--){
			if(spade[i]==playernumber||spade[i]==-1*playernumber){
				sum+=10;
			}
			if(clover[i]==playernumber||clover[i]==-1*playernumber){
				sum+=10;
			}
			if(heart[i]==playernumber||heart[i]==-1*playernumber){
				sum+=10;
			}
			if(dia[i]==playernumber||dia[i]==-1*playernumber){
				sum+=10;
			}
		}

		for(int i=9;i>1;i--){
			if(spade[i]==playernumber||spade[i]==-1*playernumber){
				sum+=i;
			}
			if(clover[i]==playernumber||clover[i]==-1*playernumber){
				sum+=i;
			}
			if(heart[i]==playernumber||heart[i]==-1*playernumber){
				sum+=i;
			}
			if(dia[i]==playernumber||dia[i]==-1*playernumber){
				sum+=i;
			}
		}
		
		int leftAce=0;

		if(spade[1]==playernumber||spade[1]==-1*playernumber){
			leftAce++;
		}
		
		if(clover[1]==playernumber||clover[1]==-1*playernumber){
			leftAce++;
		}
		
		if(heart[1]==playernumber||heart[1]==-1*playernumber){
			leftAce++;
		}
		
		if(dia[1]==playernumber||dia[1]==-1*playernumber){
			leftAce++;
		}
		
		while(leftAce>0){
			if(sum + 11 + leftAce -1 >21){
				sum += 1;
			}else{
				sum += 11;
			}
			leftAce--;
		}
		
		
		return sum;
	}
	
	public void firstDraw(int playernumber){
		
		this.drawCard(-1 * playernumber);
		this.drawCard(playernumber);
		
	}
	
	public String result(int playernumber){
		int yourscore = this.calculate(playernumber);
		int enemyscore = this.calculate(3-playernumber);
		
		if(yourscore == enemyscore){
			return "Draw Game";
		}
		
		if(yourscore <=21 && enemyscore <= 21){
			if(yourscore>enemyscore){
				return "You Win";
			}
		}

		if(yourscore <=21 && enemyscore > 21){
			return "You Win";
		}
		
		if(yourscore >21 && enemyscore > 21){
			if(yourscore<enemyscore){
				return "You Win";
			}
		}

		return "You Lose";
		
	}
	
	public String showcard(int playernumber){
		String str="";
		for(int i=0;i<14;i++){
			if(spade[i]==playernumber||spade[i]==-1*playernumber){
				str+="spade"+i+" ";
				System.out.println("spade"+i);
			}
			if(clover[i]==playernumber||clover[i]==-1*playernumber){
				str+="clover"+i+" ";
				System.out.println("clover"+i);
			}
			if(heart[i]==playernumber||heart[i]==-1*playernumber){
				str+="heart"+i+" ";
				System.out.println("heart"+i);
			}
			if(dia[i]==playernumber||dia[i]==-1*playernumber){
				str+="dia"+i+" ";
				System.out.println("dia"+i);
			}

		}
		return str;
	}
	
	public static void main(String[] args){
		ViewInfo viewinfo = new ViewInfo();
		
		viewinfo.firstDraw(1);
		viewinfo.drawCard(1);
		viewinfo.showcard(1);
		System.out.println(viewinfo.calculate(1));
		System.out.println(viewinfo.result(1));
	}
	
}
